@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceVaultAndSecretReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
 * @property secretUrl Secret URL which contains the protected settings of the extension
 * @property sourceVault The ARM Resource ID of the Key Vault
 */
public data class CloudServiceVaultAndSecretReferenceArgs(
    public val secretUrl: Output<String>? = null,
    public val sourceVault: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceVaultAndSecretReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceVaultAndSecretReferenceArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceVaultAndSecretReferenceArgs.builder()
            .secretUrl(secretUrl?.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CloudServiceVaultAndSecretReferenceArgs].
 */
@PulumiTagMarker
public class CloudServiceVaultAndSecretReferenceArgsBuilder internal constructor() {
    private var secretUrl: Output<String>? = null

    private var sourceVault: Output<SubResourceArgs>? = null

    /**
     * @param value Secret URL which contains the protected settings of the extension
     */
    @JvmName("gcwwgrkoswxijuie")
    public suspend fun secretUrl(`value`: Output<String>) {
        this.secretUrl = value
    }

    /**
     * @param value The ARM Resource ID of the Key Vault
     */
    @JvmName("wfvrwroantmpydkb")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value Secret URL which contains the protected settings of the extension
     */
    @JvmName("voyedictvjlypusu")
    public suspend fun secretUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretUrl = mapped
    }

    /**
     * @param value The ARM Resource ID of the Key Vault
     */
    @JvmName("jkgeinchmaejlfbc")
    public suspend fun sourceVault(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The ARM Resource ID of the Key Vault
     */
    @JvmName("pjelaxcnoimhardb")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): CloudServiceVaultAndSecretReferenceArgs =
        CloudServiceVaultAndSecretReferenceArgs(
            secretUrl = secretUrl,
            sourceVault = sourceVault,
        )
}
