@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceVaultSecretGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a set of certificates which are all in the same Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
 * @property vaultCertificates The list of key vault references in SourceVault which contain certificates.
 */
public data class CloudServiceVaultSecretGroupArgs(
    public val sourceVault: Output<SubResourceArgs>? = null,
    public val vaultCertificates: Output<List<CloudServiceVaultCertificateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceVaultSecretGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceVaultSecretGroupArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceVaultSecretGroupArgs.builder()
            .sourceVault(sourceVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultCertificates(
                vaultCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServiceVaultSecretGroupArgs].
 */
@PulumiTagMarker
public class CloudServiceVaultSecretGroupArgsBuilder internal constructor() {
    private var sourceVault: Output<SubResourceArgs>? = null

    private var vaultCertificates: Output<List<CloudServiceVaultCertificateArgs>>? = null

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("qxdjhjsmfprwqjux")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("kgvtjnanwgmighjo")
    public suspend fun vaultCertificates(`value`: Output<List<CloudServiceVaultCertificateArgs>>) {
        this.vaultCertificates = value
    }

    @JvmName("qvhyfuqxhwmdijuf")
    public suspend fun vaultCertificates(vararg values: Output<CloudServiceVaultCertificateArgs>) {
        this.vaultCertificates = Output.all(values.asList())
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("ydgjvocxbodhvwak")
    public suspend fun vaultCertificates(values: List<Output<CloudServiceVaultCertificateArgs>>) {
        this.vaultCertificates = Output.all(values)
    }

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("dusaohdhtmtsmtqb")
    public suspend fun sourceVault(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("fwpkadqjigclfdff")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("hfkxatptcbescwah")
    public suspend fun vaultCertificates(`value`: List<CloudServiceVaultCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("lilwkbxuekvfxglj")
    public suspend fun vaultCertificates(argument: List<suspend CloudServiceVaultCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CloudServiceVaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("vsfpqrkuonaywgbd")
    public suspend fun vaultCertificates(vararg argument: suspend CloudServiceVaultCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CloudServiceVaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("srsrilhqpdsdmehc")
    public suspend fun vaultCertificates(argument: suspend CloudServiceVaultCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CloudServiceVaultCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("blvfnxnimlvdkctx")
    public suspend fun vaultCertificates(vararg values: CloudServiceVaultCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    internal fun build(): CloudServiceVaultSecretGroupArgs = CloudServiceVaultSecretGroupArgs(
        sourceVault = sourceVault,
        vaultCertificates = vaultCertificates,
    )
}
