@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DataDiskImageEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains encryption settings for a data disk image.
 * @property diskEncryptionSetId A relative URI containing the resource ID of the disk encryption set.
 * @property lun This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
 */
public data class DataDiskImageEncryptionArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val lun: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DataDiskImageEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DataDiskImageEncryptionArgs =
        com.pulumi.azurenative.compute.inputs.DataDiskImageEncryptionArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .lun(lun.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataDiskImageEncryptionArgs].
 */
@PulumiTagMarker
public class DataDiskImageEncryptionArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var lun: Output<Int>? = null

    /**
     * @param value A relative URI containing the resource ID of the disk encryption set.
     */
    @JvmName("fjdmxlparaaoqfwf")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
     */
    @JvmName("injvldpapufqqoou")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value A relative URI containing the resource ID of the disk encryption set.
     */
    @JvmName("wwynrrryrsejhmxk")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
     */
    @JvmName("dnpcjdapagxvbpfk")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    internal fun build(): DataDiskImageEncryptionArgs = DataDiskImageEncryptionArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        lun = lun ?: throw PulumiNullFieldException("lun"),
    )
}
