@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DiskEncryptionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a Encryption Settings for a Disk
 * @property diskEncryptionKey Specifies the location of the disk encryption key, which is a Key Vault Secret.
 * @property enabled Specifies whether disk encryption should be enabled on the virtual machine.
 * @property keyEncryptionKey Specifies the location of the key encryption key in Key Vault.
 */
public data class DiskEncryptionSettingsArgs(
    public val diskEncryptionKey: Output<KeyVaultSecretReferenceArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DiskEncryptionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DiskEncryptionSettingsArgs =
        com.pulumi.azurenative.compute.inputs.DiskEncryptionSettingsArgs.builder()
            .diskEncryptionKey(diskEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyEncryptionKey(
                keyEncryptionKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class DiskEncryptionSettingsArgsBuilder internal constructor() {
    private var diskEncryptionKey: Output<KeyVaultSecretReferenceArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null

    /**
     * @param value Specifies the location of the disk encryption key, which is a Key Vault Secret.
     */
    @JvmName("phdffbluogcjfasb")
    public suspend fun diskEncryptionKey(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.diskEncryptionKey = value
    }

    /**
     * @param value Specifies whether disk encryption should be enabled on the virtual machine.
     */
    @JvmName("grjpmefeoyfkstcb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the location of the key encryption key in Key Vault.
     */
    @JvmName("cjurkdcgretqurvb")
    public suspend fun keyEncryptionKey(`value`: Output<KeyVaultKeyReferenceArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Specifies the location of the disk encryption key, which is a Key Vault Secret.
     */
    @JvmName("pixtcvbfcbodpbrd")
    public suspend fun diskEncryptionKey(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionKey = mapped
    }

    /**
     * @param argument Specifies the location of the disk encryption key, which is a Key Vault Secret.
     */
    @JvmName("yeyqnvdarvatyixf")
    public suspend fun diskEncryptionKey(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionKey = mapped
    }

    /**
     * @param value Specifies whether disk encryption should be enabled on the virtual machine.
     */
    @JvmName("yqtsvggbraigkcud")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the location of the key encryption key in Key Vault.
     */
    @JvmName("dvxngxulgopxrykk")
    public suspend fun keyEncryptionKey(`value`: KeyVaultKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Specifies the location of the key encryption key in Key Vault.
     */
    @JvmName("woffjadetombljvm")
    public suspend fun keyEncryptionKey(argument: suspend KeyVaultKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    internal fun build(): DiskEncryptionSettingsArgs = DiskEncryptionSettingsArgs(
        diskEncryptionKey = diskEncryptionKey,
        enabled = enabled,
        keyEncryptionKey = keyEncryptionKey,
    )
}
