@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DiskRestorePointAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Disk Restore Point details.
 * @property encryption Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
 * @property sourceDiskRestorePoint Resource Id of the source disk restore point.
 */
public data class DiskRestorePointAttributesArgs(
    public val encryption: Output<RestorePointEncryptionArgs>? = null,
    public val sourceDiskRestorePoint: Output<ApiEntityReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DiskRestorePointAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DiskRestorePointAttributesArgs =
        com.pulumi.azurenative.compute.inputs.DiskRestorePointAttributesArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceDiskRestorePoint(
                sourceDiskRestorePoint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskRestorePointAttributesArgs].
 */
@PulumiTagMarker
public class DiskRestorePointAttributesArgsBuilder internal constructor() {
    private var encryption: Output<RestorePointEncryptionArgs>? = null

    private var sourceDiskRestorePoint: Output<ApiEntityReferenceArgs>? = null

    /**
     * @param value Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
     */
    @JvmName("iylgvoobqjhbfenj")
    public suspend fun encryption(`value`: Output<RestorePointEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Resource Id of the source disk restore point.
     */
    @JvmName("kfbtehthnflddpob")
    public suspend fun sourceDiskRestorePoint(`value`: Output<ApiEntityReferenceArgs>) {
        this.sourceDiskRestorePoint = value
    }

    /**
     * @param value Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
     */
    @JvmName("jfwdqckynumxreyb")
    public suspend fun encryption(`value`: RestorePointEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.
     */
    @JvmName("elkiohcdhoxjaswq")
    public suspend fun encryption(argument: suspend RestorePointEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePointEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Resource Id of the source disk restore point.
     */
    @JvmName("poliksggsvemmnkd")
    public suspend fun sourceDiskRestorePoint(`value`: ApiEntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDiskRestorePoint = mapped
    }

    /**
     * @param argument Resource Id of the source disk restore point.
     */
    @JvmName("ncsegopnrecyjbet")
    public suspend fun sourceDiskRestorePoint(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceDiskRestorePoint = mapped
    }

    internal fun build(): DiskRestorePointAttributesArgs = DiskRestorePointAttributesArgs(
        encryption = encryption,
        sourceDiskRestorePoint = sourceDiskRestorePoint,
    )
}
