@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DiskSkuArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskStorageAccountTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
 * @property name The sku name.
 */
public data class DiskSkuArgs(
    public val name: Output<Either<String, DiskStorageAccountTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DiskSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DiskSkuArgs =
        com.pulumi.azurenative.compute.inputs.DiskSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskSkuArgs].
 */
@PulumiTagMarker
public class DiskSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, DiskStorageAccountTypes>>? = null

    /**
     * @param value The sku name.
     */
    @JvmName("iniparruiphoprjv")
    public suspend fun name(`value`: Output<Either<String, DiskStorageAccountTypes>>) {
        this.name = value
    }

    /**
     * @param value The sku name.
     */
    @JvmName("gsrvofosdhgupfip")
    public suspend fun name(`value`: Either<String, DiskStorageAccountTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("eafxdniofltwcmwo")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskStorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku name.
     */
    @JvmName("aukdgcsfqtdfyhml")
    public fun name(`value`: DiskStorageAccountTypes) {
        val toBeMapped = Either.ofRight<String, DiskStorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DiskSkuArgs = DiskSkuArgs(
        name = name,
    )
}
