@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryDiskImageSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The source for the disk image.
 * @property id The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
 * @property storageAccountId The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
 * @property uri The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
 */
public data class GalleryDiskImageSourceArgs(
    public val id: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryDiskImageSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryDiskImageSourceArgs =
        com.pulumi.azurenative.compute.inputs.GalleryDiskImageSourceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryDiskImageSourceArgs].
 */
@PulumiTagMarker
public class GalleryDiskImageSourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
     */
    @JvmName("buflwikeovuwtlko")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
     */
    @JvmName("qoagiaqrlsplpiyj")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
     */
    @JvmName("tkhnokrwcwigtlkb")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
     */
    @JvmName("bnacvjgchhlahxvc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
     */
    @JvmName("ucvedwpgfdrucmmm")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
     */
    @JvmName("tdcimlehbdsydljj")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): GalleryDiskImageSourceArgs = GalleryDiskImageSourceArgs(
        id = id,
        storageAccountId = storageAccountId,
        uri = uri,
    )
}
