@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryTargetExtendedLocationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.EdgeZoneStorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property encryption Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property extendedLocation The name of the extended location.
 * @property extendedLocationReplicaCount The number of replicas of the Image Version to be created per extended location. This property is updatable.
 * @property name The name of the region.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public data class GalleryTargetExtendedLocationArgs(
    public val encryption: Output<EncryptionImagesArgs>? = null,
    public val extendedLocation: Output<GalleryExtendedLocationArgs>? = null,
    public val extendedLocationReplicaCount: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val storageAccountType: Output<Either<String, EdgeZoneStorageAccountType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryTargetExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryTargetExtendedLocationArgs =
        com.pulumi.azurenative.compute.inputs.GalleryTargetExtendedLocationArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocationReplicaCount(extendedLocationReplicaCount?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [GalleryTargetExtendedLocationArgs].
 */
@PulumiTagMarker
public class GalleryTargetExtendedLocationArgsBuilder internal constructor() {
    private var encryption: Output<EncryptionImagesArgs>? = null

    private var extendedLocation: Output<GalleryExtendedLocationArgs>? = null

    private var extendedLocationReplicaCount: Output<Int>? = null

    private var name: Output<String>? = null

    private var storageAccountType: Output<Either<String, EdgeZoneStorageAccountType>>? = null

    /**
     * @param value Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("irlfcqbbdbvvxlrt")
    public suspend fun encryption(`value`: Output<EncryptionImagesArgs>) {
        this.encryption = value
    }

    /**
     * @param value The name of the extended location.
     */
    @JvmName("yafbwyogalgyfihm")
    public suspend fun extendedLocation(`value`: Output<GalleryExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The number of replicas of the Image Version to be created per extended location. This property is updatable.
     */
    @JvmName("cxesseeugddlfaqa")
    public suspend fun extendedLocationReplicaCount(`value`: Output<Int>) {
        this.extendedLocationReplicaCount = value
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("lsmvmjryxfygrcgl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("snlesiayfopnyrip")
    public suspend fun storageAccountType(`value`: Output<Either<String, EdgeZoneStorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("immvxlcbftflwrlm")
    public suspend fun encryption(`value`: EncryptionImagesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("myjrwpdasbchydwo")
    public suspend fun encryption(argument: suspend EncryptionImagesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionImagesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The name of the extended location.
     */
    @JvmName("kcoidasdopjewide")
    public suspend fun extendedLocation(`value`: GalleryExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The name of the extended location.
     */
    @JvmName("fekkyrhabfwgbpye")
    public suspend fun extendedLocation(argument: suspend GalleryExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The number of replicas of the Image Version to be created per extended location. This property is updatable.
     */
    @JvmName("lnpniumldbajixbv")
    public suspend fun extendedLocationReplicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocationReplicaCount = mapped
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("iliexexmqbwsdnfg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("marvtqxtrekkuloa")
    public suspend fun storageAccountType(`value`: Either<String, EdgeZoneStorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("xnpdvdswjsikeuob")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EdgeZoneStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("ijmhubxkytjbwpvl")
    public fun storageAccountType(`value`: EdgeZoneStorageAccountType) {
        val toBeMapped = Either.ofRight<String, EdgeZoneStorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): GalleryTargetExtendedLocationArgs = GalleryTargetExtendedLocationArgs(
        encryption = encryption,
        extendedLocation = extendedLocation,
        extendedLocationReplicaCount = extendedLocationReplicaCount,
        name = name,
        storageAccountType = storageAccountType,
    )
}
