@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetCapacityReservationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationGroupName The name of the capacity reservation group.
 * @property capacityReservationName The name of the capacity reservation.
 * @property expand The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the capacity reservation that is managed by the platform and can change outside of control plane operations.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetCapacityReservationPlainArgs(
    public val capacityReservationGroupName: String,
    public val capacityReservationName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetCapacityReservationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetCapacityReservationPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetCapacityReservationPlainArgs.builder()
            .capacityReservationGroupName(capacityReservationGroupName.let({ args0 -> args0 }))
            .capacityReservationName(capacityReservationName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapacityReservationPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityReservationPlainArgsBuilder internal constructor() {
    private var capacityReservationGroupName: String? = null

    private var capacityReservationName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("ajqbddqbwoeheahl")
    public suspend fun capacityReservationGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityReservationGroupName = mapped
    }

    /**
     * @param value The name of the capacity reservation.
     */
    @JvmName("pvbpimxxqnihawtu")
    public suspend fun capacityReservationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityReservationName = mapped
    }

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the capacity reservation that is managed by the platform and can change outside of control plane operations.
     */
    @JvmName("kliqbegvssbpnabo")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("widsvobbkjnprmjr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCapacityReservationPlainArgs = GetCapacityReservationPlainArgs(
        capacityReservationGroupName = capacityReservationGroupName ?: throw
            PulumiNullFieldException("capacityReservationGroupName"),
        capacityReservationName = capacityReservationName ?: throw
            PulumiNullFieldException("capacityReservationName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
