@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetCloudServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudServiceName Name of the cloud service.
 * @property resourceGroupName Name of the resource group.
 */
public data class GetCloudServicePlainArgs(
    public val cloudServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetCloudServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetCloudServicePlainArgs =
        com.pulumi.azurenative.compute.inputs.GetCloudServicePlainArgs.builder()
            .cloudServiceName(cloudServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudServicePlainArgs].
 */
@PulumiTagMarker
public class GetCloudServicePlainArgsBuilder internal constructor() {
    private var cloudServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the cloud service.
     */
    @JvmName("iqnftginirfrgryp")
    public suspend fun cloudServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudServiceName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("knkusfmhbjqoubvf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudServicePlainArgs = GetCloudServicePlainArgs(
        cloudServiceName = cloudServiceName ?: throw PulumiNullFieldException("cloudServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
