@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDiskAccessAPrivateEndpointConnectionPlainArgs(
    public val diskAccessName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetDiskAccessAPrivateEndpointConnectionPlainArgs.builder()
            .diskAccessName(diskAccessName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskAccessAPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetDiskAccessAPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var diskAccessName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("aecyghtqvaenokrr")
    public suspend fun diskAccessName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diskAccessName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("aytqjexfuhnelgsr")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mvoabbrbxulqbybk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiskAccessAPrivateEndpointConnectionPlainArgs =
        GetDiskAccessAPrivateEndpointConnectionPlainArgs(
            diskAccessName = diskAccessName ?: throw PulumiNullFieldException("diskAccessName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
