@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetDiskEncryptionSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDiskEncryptionSetPlainArgs(
    public val diskEncryptionSetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetDiskEncryptionSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetDiskEncryptionSetPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetDiskEncryptionSetPlainArgs.builder()
            .diskEncryptionSetName(diskEncryptionSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskEncryptionSetPlainArgs].
 */
@PulumiTagMarker
public class GetDiskEncryptionSetPlainArgsBuilder internal constructor() {
    private var diskEncryptionSetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the disk encryption set that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("kgplvodrutogcqnu")
    public suspend fun diskEncryptionSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diskEncryptionSetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yhricenxfmyseydr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiskEncryptionSetPlainArgs = GetDiskEncryptionSetPlainArgs(
        diskEncryptionSetName = diskEncryptionSetName ?: throw
            PulumiNullFieldException("diskEncryptionSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
