@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property imageName The name of the image.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetImagePlainArgs(
    public val expand: String? = null,
    public val imageName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetImagePlainArgs =
        com.pulumi.azurenative.compute.inputs.GetImagePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .imageName(imageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var imageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("bwypaxgurdaqmnsu")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the image.
     */
    @JvmName("dcxicuxlvskhehwf")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ggkbiicfmmbggpdw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        expand = expand,
        imageName = imageName ?: throw PulumiNullFieldException("imageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
