@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ImageDataDiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CachingTypes
import com.pulumi.azurenative.compute.kotlin.enums.StorageAccountTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a data disk.
 * @property blobUri The Virtual Hard Disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed image disk.
 * @property diskSizeGB Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. This value cannot be larger than 1023 GB.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managedDisk.
 * @property snapshot The snapshot.
 * @property storageAccountType Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public data class ImageDataDiskArgs(
    public val blobUri: Output<String>? = null,
    public val caching: Output<CachingTypes>? = null,
    public val diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val lun: Output<Int>,
    public val managedDisk: Output<SubResourceArgs>? = null,
    public val snapshot: Output<SubResourceArgs>? = null,
    public val storageAccountType: Output<Either<String, StorageAccountTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ImageDataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ImageDataDiskArgs =
        com.pulumi.azurenative.compute.inputs.ImageDataDiskArgs.builder()
            .blobUri(blobUri?.applyValue({ args0 -> args0 }))
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskEncryptionSet(diskEncryptionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .lun(lun.applyValue({ args0 -> args0 }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshot(snapshot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ImageDataDiskArgs].
 */
@PulumiTagMarker
public class ImageDataDiskArgsBuilder internal constructor() {
    private var blobUri: Output<String>? = null

    private var caching: Output<CachingTypes>? = null

    private var diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null

    private var diskSizeGB: Output<Int>? = null

    private var lun: Output<Int>? = null

    private var managedDisk: Output<SubResourceArgs>? = null

    private var snapshot: Output<SubResourceArgs>? = null

    private var storageAccountType: Output<Either<String, StorageAccountTypes>>? = null

    /**
     * @param value The Virtual Hard Disk.
     */
    @JvmName("latjcodbwsglrhrf")
    public suspend fun blobUri(`value`: Output<String>) {
        this.blobUri = value
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("ryqmnpjihpqppqbm")
    public suspend fun caching(`value`: Output<CachingTypes>) {
        this.caching = value
    }

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed image disk.
     */
    @JvmName("hijetphwddjldrqc")
    public suspend fun diskEncryptionSet(`value`: Output<DiskEncryptionSetParametersArgs>) {
        this.diskEncryptionSet = value
    }

    /**
     * @param value Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. This value cannot be larger than 1023 GB.
     */
    @JvmName("svcouuookimipfpf")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("ouwdfipvmuurxbeq")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value The managedDisk.
     */
    @JvmName("dsrabkfrtabsnngc")
    public suspend fun managedDisk(`value`: Output<SubResourceArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value The snapshot.
     */
    @JvmName("jiosgxosocakfjaa")
    public suspend fun snapshot(`value`: Output<SubResourceArgs>) {
        this.snapshot = value
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("bsxljdhadafkuxgb")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountTypes>>) {
        this.storageAccountType = value
    }

    /**
     * @param value The Virtual Hard Disk.
     */
    @JvmName("enrplwlcjkjklmam")
    public suspend fun blobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobUri = mapped
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("olmvljpfxtbqbnie")
    public suspend fun caching(`value`: CachingTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed image disk.
     */
    @JvmName("tgqgpftgcugqiwwe")
    public suspend fun diskEncryptionSet(`value`: DiskEncryptionSetParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSet = mapped
    }

    /**
     * @param argument Specifies the customer managed disk encryption set resource id for the managed image disk.
     */
    @JvmName("vpgmvskhovqgpwgx")
    public suspend fun diskEncryptionSet(argument: suspend DiskEncryptionSetParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionSetParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionSet = mapped
    }

    /**
     * @param value Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. This value cannot be larger than 1023 GB.
     */
    @JvmName("kunuanjtoelrvidh")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("wwaxvuqugvtqblyc")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value The managedDisk.
     */
    @JvmName("fqfablwmyfwqtgti")
    public suspend fun managedDisk(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument The managedDisk.
     */
    @JvmName("pkvkcibspfjyumex")
    public suspend fun managedDisk(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value The snapshot.
     */
    @JvmName("xwywetdaldtatayi")
    public suspend fun snapshot(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshot = mapped
    }

    /**
     * @param argument The snapshot.
     */
    @JvmName("kawhvpxtwvsicftb")
    public suspend fun snapshot(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshot = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("ojrxngrxqdaijfew")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("bcyofnhargmarild")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("bewwslgwnxbdouvy")
    public fun storageAccountType(`value`: StorageAccountTypes) {
        val toBeMapped = Either.ofRight<String, StorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): ImageDataDiskArgs = ImageDataDiskArgs(
        blobUri = blobUri,
        caching = caching,
        diskEncryptionSet = diskEncryptionSet,
        diskSizeGB = diskSizeGB,
        lun = lun ?: throw PulumiNullFieldException("lun"),
        managedDisk = managedDisk,
        snapshot = snapshot,
        storageAccountType = storageAccountType,
    )
}
