@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.LinuxPatchAssessmentMode
import com.pulumi.azurenative.compute.kotlin.enums.LinuxVMGuestPatchMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies settings related to VM Guest Patching on Linux.
 * @property assessmentMode Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 * @property automaticByPlatformSettings Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
 * @property patchMode Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
 */
public data class LinuxPatchSettingsArgs(
    public val assessmentMode: Output<Either<String, LinuxPatchAssessmentMode>>? = null,
    public val automaticByPlatformSettings: Output<LinuxVMGuestPatchAutomaticByPlatformSettingsArgs>? =
        null,
    public val patchMode: Output<Either<String, LinuxVMGuestPatchMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs =
        com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs.builder()
            .assessmentMode(
                assessmentMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .automaticByPlatformSettings(
                automaticByPlatformSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .patchMode(
                patchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LinuxPatchSettingsArgs].
 */
@PulumiTagMarker
public class LinuxPatchSettingsArgsBuilder internal constructor() {
    private var assessmentMode: Output<Either<String, LinuxPatchAssessmentMode>>? = null

    private var automaticByPlatformSettings: Output<LinuxVMGuestPatchAutomaticByPlatformSettingsArgs>? =
        null

    private var patchMode: Output<Either<String, LinuxVMGuestPatchMode>>? = null

    /**
     * @param value Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("diffiglagtewmxnx")
    public suspend fun assessmentMode(`value`: Output<Either<String, LinuxPatchAssessmentMode>>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
     */
    @JvmName("lnkfvwxgtekqbler")
    public suspend fun automaticByPlatformSettings(`value`: Output<LinuxVMGuestPatchAutomaticByPlatformSettingsArgs>) {
        this.automaticByPlatformSettings = value
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
     */
    @JvmName("umrhmylrarpkjiil")
    public suspend fun patchMode(`value`: Output<Either<String, LinuxVMGuestPatchMode>>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("rhpbitpxynirnvqs")
    public suspend fun assessmentMode(`value`: Either<String, LinuxPatchAssessmentMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("njwdekfgnfxijhsp")
    public fun assessmentMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinuxPatchAssessmentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("waxxxkyqlinemnrr")
    public fun assessmentMode(`value`: LinuxPatchAssessmentMode) {
        val toBeMapped = Either.ofRight<String, LinuxPatchAssessmentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
     */
    @JvmName("pqlwpafuuipgvagn")
    public suspend fun automaticByPlatformSettings(`value`: LinuxVMGuestPatchAutomaticByPlatformSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticByPlatformSettings = mapped
    }

    /**
     * @param argument Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
     */
    @JvmName("krwmwaoqnjbbdkau")
    public suspend fun automaticByPlatformSettings(argument: suspend LinuxVMGuestPatchAutomaticByPlatformSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxVMGuestPatchAutomaticByPlatformSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.automaticByPlatformSettings = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
     */
    @JvmName("kylnfierndwaobem")
    public suspend fun patchMode(`value`: Either<String, LinuxVMGuestPatchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
     */
    @JvmName("avotsksstfakyglj")
    public fun patchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinuxVMGuestPatchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
     */
    @JvmName("rtquaunwphnmysog")
    public fun patchMode(`value`: LinuxVMGuestPatchMode) {
        val toBeMapped = Either.ofRight<String, LinuxVMGuestPatchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): LinuxPatchSettingsArgs = LinuxPatchSettingsArgs(
        assessmentMode = assessmentMode,
        automaticByPlatformSettings = automaticByPlatformSettings,
        patchMode = patchMode,
    )
}
