@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.StorageAccountTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The parameters of a managed disk.
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed disk.
 * @property id Resource Id
 * @property securityProfile Specifies the security profile for the managed disk.
 * @property storageAccountType Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public data class ManagedDiskParametersArgs(
    public val diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null,
    public val id: Output<String>? = null,
    public val securityProfile: Output<VMDiskSecurityProfileArgs>? = null,
    public val storageAccountType: Output<Either<String, StorageAccountTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs =
        com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs.builder()
            .diskEncryptionSet(diskEncryptionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ManagedDiskParametersArgs].
 */
@PulumiTagMarker
public class ManagedDiskParametersArgsBuilder internal constructor() {
    private var diskEncryptionSet: Output<DiskEncryptionSetParametersArgs>? = null

    private var id: Output<String>? = null

    private var securityProfile: Output<VMDiskSecurityProfileArgs>? = null

    private var storageAccountType: Output<Either<String, StorageAccountTypes>>? = null

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed disk.
     */
    @JvmName("hvcenhhhwjsorrpx")
    public suspend fun diskEncryptionSet(`value`: Output<DiskEncryptionSetParametersArgs>) {
        this.diskEncryptionSet = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("wsvkuxxemydkkmfn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies the security profile for the managed disk.
     */
    @JvmName("milorjcvfthfrlla")
    public suspend fun securityProfile(`value`: Output<VMDiskSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("aicmvnmlfrqidxxe")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountTypes>>) {
        this.storageAccountType = value
    }

    /**
     * @param value Specifies the customer managed disk encryption set resource id for the managed disk.
     */
    @JvmName("vnvobrjjqdynkisj")
    public suspend fun diskEncryptionSet(`value`: DiskEncryptionSetParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSet = mapped
    }

    /**
     * @param argument Specifies the customer managed disk encryption set resource id for the managed disk.
     */
    @JvmName("uajtgsjwthhutqfp")
    public suspend fun diskEncryptionSet(argument: suspend DiskEncryptionSetParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionSetParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionSet = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("iekhlxxdodywhrej")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies the security profile for the managed disk.
     */
    @JvmName("inhaagmwsrgekwsf")
    public suspend fun securityProfile(`value`: VMDiskSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Specifies the security profile for the managed disk.
     */
    @JvmName("xkfmfmnokomifgvk")
    public suspend fun securityProfile(argument: suspend VMDiskSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VMDiskSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("plbxwcqkkkeeyejy")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("vmhqfbmlqjaenpdm")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
     */
    @JvmName("mhjxnxusrmfmtyty")
    public fun storageAccountType(`value`: StorageAccountTypes) {
        val toBeMapped = Either.ofRight<String, StorageAccountTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): ManagedDiskParametersArgs = ManagedDiskParametersArgs(
        diskEncryptionSet = diskEncryptionSet,
        id = id,
        securityProfile = securityProfile,
        storageAccountType = storageAccountType,
    )
}
