@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.OSDiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CachingTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskCreateOptionTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskDeleteOptionTypes
import com.pulumi.azurenative.compute.kotlin.enums.OperatingSystemTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
 * @property deleteOption Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
 * @property diffDiskSettings Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property encryptionSettings Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.
 * @property image The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 * @property vhd The virtual hard disk.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class OSDiskArgs(
    public val caching: Output<CachingTypes>? = null,
    public val createOption: Output<Either<String, DiskCreateOptionTypes>>,
    public val deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null,
    public val diffDiskSettings: Output<DiffDiskSettingsArgs>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val encryptionSettings: Output<DiskEncryptionSettingsArgs>? = null,
    public val image: Output<VirtualHardDiskArgs>? = null,
    public val managedDisk: Output<ManagedDiskParametersArgs>? = null,
    public val name: Output<String>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val vhd: Output<VirtualHardDiskArgs>? = null,
    public val writeAcceleratorEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.OSDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.OSDiskArgs =
        com.pulumi.azurenative.compute.inputs.OSDiskArgs.builder()
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createOption(
                createOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diffDiskSettings(diffDiskSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .encryptionSettings(
                encryptionSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vhd(vhd?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .writeAcceleratorEnabled(writeAcceleratorEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OSDiskArgs].
 */
@PulumiTagMarker
public class OSDiskArgsBuilder internal constructor() {
    private var caching: Output<CachingTypes>? = null

    private var createOption: Output<Either<String, DiskCreateOptionTypes>>? = null

    private var deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null

    private var diffDiskSettings: Output<DiffDiskSettingsArgs>? = null

    private var diskSizeGB: Output<Int>? = null

    private var encryptionSettings: Output<DiskEncryptionSettingsArgs>? = null

    private var image: Output<VirtualHardDiskArgs>? = null

    private var managedDisk: Output<ManagedDiskParametersArgs>? = null

    private var name: Output<String>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var vhd: Output<VirtualHardDiskArgs>? = null

    private var writeAcceleratorEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("rphugukkidmgrtbl")
    public suspend fun caching(`value`: Output<CachingTypes>) {
        this.caching = value
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("dtquxyipxcnuixrf")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOptionTypes>>) {
        this.createOption = value
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
     */
    @JvmName("gfwlutyjajualbpl")
    public suspend fun deleteOption(`value`: Output<Either<String, DiskDeleteOptionTypes>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
     */
    @JvmName("fjfdvxfhsonmswlq")
    public suspend fun diffDiskSettings(`value`: Output<DiffDiskSettingsArgs>) {
        this.diffDiskSettings = value
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("qsfyjgwfhfdktxsj")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.
     */
    @JvmName("jhounggptfgyshor")
    public suspend fun encryptionSettings(`value`: Output<DiskEncryptionSettingsArgs>) {
        this.encryptionSettings = value
    }

    /**
     * @param value The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("xefxvmarmaxgldxv")
    public suspend fun image(`value`: Output<VirtualHardDiskArgs>) {
        this.image = value
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("yghmsqreyqxddnry")
    public suspend fun managedDisk(`value`: Output<ManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value The disk name.
     */
    @JvmName("edfjwkmgkhbdhmys")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("aqveyfvmxmensdrj")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("qpqmplkdtexmggnu")
    public suspend fun vhd(`value`: Output<VirtualHardDiskArgs>) {
        this.vhd = value
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("djbrylcpcsvfvqep")
    public suspend fun writeAcceleratorEnabled(`value`: Output<Boolean>) {
        this.writeAcceleratorEnabled = value
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("uuhrynyoteimvskr")
    public suspend fun caching(`value`: CachingTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("tflivpalhuabjpke")
    public suspend fun createOption(`value`: Either<String, DiskCreateOptionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("hvnhlfibyjnicmcc")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
     */
    @JvmName("nicdgpmtcnhqmqlj")
    public fun createOption(`value`: DiskCreateOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
     */
    @JvmName("flfufjpxwmmrgluf")
    public suspend fun deleteOption(`value`: Either<String, DiskDeleteOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
     */
    @JvmName("hgqfgjymtnbusauw")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
     */
    @JvmName("yvqpdybuudwvxbsn")
    public fun deleteOption(`value`: DiskDeleteOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
     */
    @JvmName("ffevoibtxfoyhioj")
    public suspend fun diffDiskSettings(`value`: DiffDiskSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffDiskSettings = mapped
    }

    /**
     * @param argument Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
     */
    @JvmName("chktnfidblcwuhej")
    public suspend fun diffDiskSettings(argument: suspend DiffDiskSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DiffDiskSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diffDiskSettings = mapped
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("qqewqawhecxvbttr")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.
     */
    @JvmName("dckpfennnafvnntg")
    public suspend fun encryptionSettings(`value`: DiskEncryptionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettings = mapped
    }

    /**
     * @param argument Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.
     */
    @JvmName("djcqpasxvhriysxt")
    public suspend fun encryptionSettings(argument: suspend DiskEncryptionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param value The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("lobpedyduetfdnfo")
    public suspend fun image(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    @JvmName("vgocmohlqhgcpsri")
    public suspend fun image(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("lkbduocdisejfjwx")
    public suspend fun managedDisk(`value`: ManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument The managed disk parameters.
     */
    @JvmName("ovmynlkntbcdijxs")
    public suspend fun managedDisk(argument: suspend ManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("borgojkkrknfhjwj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("opttihwhklejoorr")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The virtual hard disk.
     */
    @JvmName("xcpfgalbvupkvvdk")
    public suspend fun vhd(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhd = mapped
    }

    /**
     * @param argument The virtual hard disk.
     */
    @JvmName("fycsqbltkwhjbeci")
    public suspend fun vhd(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhd = mapped
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("vokphcmbtfccfpsl")
    public suspend fun writeAcceleratorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAcceleratorEnabled = mapped
    }

    internal fun build(): OSDiskArgs = OSDiskArgs(
        caching = caching,
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        deleteOption = deleteOption,
        diffDiskSettings = diffDiskSettings,
        diskSizeGB = diskSizeGB,
        encryptionSettings = encryptionSettings,
        image = image,
        managedDisk = managedDisk,
        name = name,
        osType = osType,
        vhd = vhd,
        writeAcceleratorEnabled = writeAcceleratorEnabled,
    )
}
