@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.OSDiskImageSecurityProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ConfidentialVMEncryptionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains security profile for an OS disk image.
 * @property confidentialVMEncryptionType confidential VM encryption types
 * @property secureVMDiskEncryptionSetId secure VM disk encryption set id
 */
public data class OSDiskImageSecurityProfileArgs(
    public val confidentialVMEncryptionType: Output<Either<String, ConfidentialVMEncryptionType>>? =
        null,
    public val secureVMDiskEncryptionSetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.OSDiskImageSecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.OSDiskImageSecurityProfileArgs =
        com.pulumi.azurenative.compute.inputs.OSDiskImageSecurityProfileArgs.builder()
            .confidentialVMEncryptionType(
                confidentialVMEncryptionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .secureVMDiskEncryptionSetId(secureVMDiskEncryptionSetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OSDiskImageSecurityProfileArgs].
 */
@PulumiTagMarker
public class OSDiskImageSecurityProfileArgsBuilder internal constructor() {
    private var confidentialVMEncryptionType: Output<Either<String, ConfidentialVMEncryptionType>>? =
        null

    private var secureVMDiskEncryptionSetId: Output<String>? = null

    /**
     * @param value confidential VM encryption types
     */
    @JvmName("xlkpcuspuulpdeaj")
    public suspend fun confidentialVMEncryptionType(`value`: Output<Either<String, ConfidentialVMEncryptionType>>) {
        this.confidentialVMEncryptionType = value
    }

    /**
     * @param value secure VM disk encryption set id
     */
    @JvmName("kgijpwhffpbogmyn")
    public suspend fun secureVMDiskEncryptionSetId(`value`: Output<String>) {
        this.secureVMDiskEncryptionSetId = value
    }

    /**
     * @param value confidential VM encryption types
     */
    @JvmName("ksdkbqdmxugihkrg")
    public suspend fun confidentialVMEncryptionType(`value`: Either<String, ConfidentialVMEncryptionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialVMEncryptionType = mapped
    }

    /**
     * @param value confidential VM encryption types
     */
    @JvmName("kewlksctavyqckgw")
    public fun confidentialVMEncryptionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfidentialVMEncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confidentialVMEncryptionType = mapped
    }

    /**
     * @param value confidential VM encryption types
     */
    @JvmName("aibytlcfmnfamsor")
    public fun confidentialVMEncryptionType(`value`: ConfidentialVMEncryptionType) {
        val toBeMapped = Either.ofRight<String, ConfidentialVMEncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confidentialVMEncryptionType = mapped
    }

    /**
     * @param value secure VM disk encryption set id
     */
    @JvmName("buqqoebdvvhodopw")
    public suspend fun secureVMDiskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureVMDiskEncryptionSetId = mapped
    }

    internal fun build(): OSDiskImageSecurityProfileArgs = OSDiskImageSecurityProfileArgs(
        confidentialVMEncryptionType = confidentialVMEncryptionType,
        secureVMDiskEncryptionSetId = secureVMDiskEncryptionSetId,
    )
}
