@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the target splits for Spot and Regular priority VMs within a scale set with flexible orchestration mode. With this property the customer is able to specify the base number of regular priority VMs created as the VMSS flex instance scales out and the split between Spot and Regular priority VMs after this base target has been reached.
 * @property baseRegularPriorityCount The base number of regular priority VMs that will be created in this scale set as it scales out.
 * @property regularPriorityPercentageAboveBase The percentage of VM instances, after the base regular priority count has been reached, that are expected to use regular priority.
 */
public data class PriorityMixPolicyArgs(
    public val baseRegularPriorityCount: Output<Int>? = null,
    public val regularPriorityPercentageAboveBase: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs =
        com.pulumi.azurenative.compute.inputs.PriorityMixPolicyArgs.builder()
            .baseRegularPriorityCount(baseRegularPriorityCount?.applyValue({ args0 -> args0 }))
            .regularPriorityPercentageAboveBase(
                regularPriorityPercentageAboveBase?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [PriorityMixPolicyArgs].
 */
@PulumiTagMarker
public class PriorityMixPolicyArgsBuilder internal constructor() {
    private var baseRegularPriorityCount: Output<Int>? = null

    private var regularPriorityPercentageAboveBase: Output<Int>? = null

    /**
     * @param value The base number of regular priority VMs that will be created in this scale set as it scales out.
     */
    @JvmName("laflcmelgdmuislq")
    public suspend fun baseRegularPriorityCount(`value`: Output<Int>) {
        this.baseRegularPriorityCount = value
    }

    /**
     * @param value The percentage of VM instances, after the base regular priority count has been reached, that are expected to use regular priority.
     */
    @JvmName("jhapapkmhrehdmya")
    public suspend fun regularPriorityPercentageAboveBase(`value`: Output<Int>) {
        this.regularPriorityPercentageAboveBase = value
    }

    /**
     * @param value The base number of regular priority VMs that will be created in this scale set as it scales out.
     */
    @JvmName("vygkdecilojaeopp")
    public suspend fun baseRegularPriorityCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseRegularPriorityCount = mapped
    }

    /**
     * @param value The percentage of VM instances, after the base regular priority count has been reached, that are expected to use regular priority.
     */
    @JvmName("ovqjgrmcuduyhdxa")
    public suspend fun regularPriorityPercentageAboveBase(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regularPriorityPercentageAboveBase = mapped
    }

    internal fun build(): PriorityMixPolicyArgs = PriorityMixPolicyArgs(
        baseRegularPriorityCount = baseRegularPriorityCount,
        regularPriorityPercentageAboveBase = regularPriorityPercentageAboveBase,
    )
}
