@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.PurchasePlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The Offer Promotion Code.
 * @property publisher The publisher ID.
 */
public data class PurchasePlanArgs(
    public val name: Output<String>,
    public val product: Output<String>,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.PurchasePlanArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.PurchasePlanArgs =
        com.pulumi.azurenative.compute.inputs.PurchasePlanArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .product(product.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PurchasePlanArgs].
 */
@PulumiTagMarker
public class PurchasePlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The plan ID.
     */
    @JvmName("fqcitnhbfvlioblt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("eqbcvsxxrjekxjeu")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The Offer Promotion Code.
     */
    @JvmName("hqjgoxtigmglbmnn")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("tnhjjauokydlquag")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("gotqxckbxpbhloyg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("exxwepxasnkqkafc")
    public suspend fun product(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The Offer Promotion Code.
     */
    @JvmName("hbonkgmbjgkgldvk")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("delbapolnucuamvm")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): PurchasePlanArgs = PurchasePlanArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        product = product ?: throw PulumiNullFieldException("product"),
        promotionCode = promotionCode,
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
    )
}
