@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ResourceRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the resource range.
 * @property max The maximum number of the resource.
 * @property min The minimum number of the resource.
 */
public data class ResourceRangeArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ResourceRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ResourceRangeArgs =
        com.pulumi.azurenative.compute.inputs.ResourceRangeArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRangeArgs].
 */
@PulumiTagMarker
public class ResourceRangeArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value The maximum number of the resource.
     */
    @JvmName("mpujmdloqpdfcoqw")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value The minimum number of the resource.
     */
    @JvmName("afachddvhlhmooma")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value The maximum number of the resource.
     */
    @JvmName("lxkosardjuofvoti")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum number of the resource.
     */
    @JvmName("wpxgyfvnvxcsrcmh")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): ResourceRangeArgs = ResourceRangeArgs(
        max = max,
        min = min,
    )
}
