@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RestorePointSourceVMOSDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an Operating System disk.
 * @property diskRestorePoint Contains Disk Restore Point properties.
 * @property managedDisk Gets the managed disk details
 */
public data class RestorePointSourceVMOSDiskArgs(
    public val diskRestorePoint: Output<DiskRestorePointAttributesArgs>? = null,
    public val managedDisk: Output<ManagedDiskParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RestorePointSourceVMOSDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RestorePointSourceVMOSDiskArgs =
        com.pulumi.azurenative.compute.inputs.RestorePointSourceVMOSDiskArgs.builder()
            .diskRestorePoint(diskRestorePoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RestorePointSourceVMOSDiskArgs].
 */
@PulumiTagMarker
public class RestorePointSourceVMOSDiskArgsBuilder internal constructor() {
    private var diskRestorePoint: Output<DiskRestorePointAttributesArgs>? = null

    private var managedDisk: Output<ManagedDiskParametersArgs>? = null

    /**
     * @param value Contains Disk Restore Point properties.
     */
    @JvmName("mtdsulujhhnmswad")
    public suspend fun diskRestorePoint(`value`: Output<DiskRestorePointAttributesArgs>) {
        this.diskRestorePoint = value
    }

    /**
     * @param value Gets the managed disk details
     */
    @JvmName("hqeeyemsmarvahou")
    public suspend fun managedDisk(`value`: Output<ManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value Contains Disk Restore Point properties.
     */
    @JvmName("jqeusnrxnycsuemm")
    public suspend fun diskRestorePoint(`value`: DiskRestorePointAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskRestorePoint = mapped
    }

    /**
     * @param argument Contains Disk Restore Point properties.
     */
    @JvmName("oohxpbpyisrjahku")
    public suspend fun diskRestorePoint(argument: suspend DiskRestorePointAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = DiskRestorePointAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskRestorePoint = mapped
    }

    /**
     * @param value Gets the managed disk details
     */
    @JvmName("xheanhcidmhvxktb")
    public suspend fun managedDisk(`value`: ManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument Gets the managed disk details
     */
    @JvmName("mwdyjefhkraodlsd")
    public suspend fun managedDisk(argument: suspend ManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    internal fun build(): RestorePointSourceVMOSDiskArgs = RestorePointSourceVMOSDiskArgs(
        diskRestorePoint = diskRestorePoint,
        managedDisk = managedDisk,
    )
}
