@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *  Contains clientId or objectId (use only one, not both) of a user-assigned managed identity that has access to storage blob used in Run Command. Use an empty RunCommandManagedIdentity object in case of system-assigned identity. Make sure the Azure storage blob exists in case of scriptUri, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment with scriptUri blob and 'Storage Blob Data Contributor' for Append blobs(outputBlobUri, errorBlobUri). In case of user assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged.
 * @property clientId Client Id (GUID value) of the user-assigned managed identity. ObjectId should not be used if this is provided.
 * @property objectId Object Id (GUID value) of the user-assigned managed identity. ClientId should not be used if this is provided.
 */
public data class RunCommandManagedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val objectId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs =
        com.pulumi.azurenative.compute.inputs.RunCommandManagedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RunCommandManagedIdentityArgs].
 */
@PulumiTagMarker
public class RunCommandManagedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var objectId: Output<String>? = null

    /**
     * @param value Client Id (GUID value) of the user-assigned managed identity. ObjectId should not be used if this is provided.
     */
    @JvmName("mbxicmxljuqcaaaq")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Object Id (GUID value) of the user-assigned managed identity. ClientId should not be used if this is provided.
     */
    @JvmName("iowwaenarhxpovnv")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Client Id (GUID value) of the user-assigned managed identity. ObjectId should not be used if this is provided.
     */
    @JvmName("okgrnlrhowymoqbr")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Object Id (GUID value) of the user-assigned managed identity. ClientId should not be used if this is provided.
     */
    @JvmName("ehyyqgexgbgybeov")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    internal fun build(): RunCommandManagedIdentityArgs = RunCommandManagedIdentityArgs(
        clientId = clientId,
        objectId = objectId,
    )
}
