@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SharingProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.GallerySharingPermissionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Profile for gallery sharing to subscription or tenant
 * @property communityGalleryInfo Information of community gallery if current gallery is shared to community.
 * @property permissions This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
 */
public data class SharingProfileArgs(
    public val communityGalleryInfo: Output<CommunityGalleryInfoArgs>? = null,
    public val permissions: Output<Either<String, GallerySharingPermissionTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SharingProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SharingProfileArgs =
        com.pulumi.azurenative.compute.inputs.SharingProfileArgs.builder()
            .communityGalleryInfo(
                communityGalleryInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SharingProfileArgs].
 */
@PulumiTagMarker
public class SharingProfileArgsBuilder internal constructor() {
    private var communityGalleryInfo: Output<CommunityGalleryInfoArgs>? = null

    private var permissions: Output<Either<String, GallerySharingPermissionTypes>>? = null

    /**
     * @param value Information of community gallery if current gallery is shared to community.
     */
    @JvmName("vmsllqidpjvveukc")
    public suspend fun communityGalleryInfo(`value`: Output<CommunityGalleryInfoArgs>) {
        this.communityGalleryInfo = value
    }

    /**
     * @param value This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
     */
    @JvmName("wvrandmxvgfcssxy")
    public suspend fun permissions(`value`: Output<Either<String, GallerySharingPermissionTypes>>) {
        this.permissions = value
    }

    /**
     * @param value Information of community gallery if current gallery is shared to community.
     */
    @JvmName("rgoqvfwxgplgsrmi")
    public suspend fun communityGalleryInfo(`value`: CommunityGalleryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityGalleryInfo = mapped
    }

    /**
     * @param argument Information of community gallery if current gallery is shared to community.
     */
    @JvmName("aramfrpkttcsjmds")
    public suspend fun communityGalleryInfo(argument: suspend CommunityGalleryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CommunityGalleryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.communityGalleryInfo = mapped
    }

    /**
     * @param value This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
     */
    @JvmName("simmqggtgdbtylhw")
    public suspend fun permissions(`value`: Either<String, GallerySharingPermissionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
     */
    @JvmName("tavludeavtosyhcr")
    public fun permissions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GallerySharingPermissionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups** <br><br> **Community**
     */
    @JvmName("aqfpvbebnwqrptbm")
    public fun permissions(`value`: GallerySharingPermissionTypes) {
        val toBeMapped = Either.ofRight<String, GallerySharingPermissionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    internal fun build(): SharingProfileArgs = SharingProfileArgs(
        communityGalleryInfo = communityGalleryInfo,
        permissions = permissions,
    )
}
