@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SourceVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * @property id Resource Id
 */
public data class SourceVaultArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SourceVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SourceVaultArgs =
        com.pulumi.azurenative.compute.inputs.SourceVaultArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceVaultArgs].
 */
@PulumiTagMarker
public class SourceVaultArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource Id
     */
    @JvmName("ehtyenrdsmjbketd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("nmsmsftgrububfqe")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SourceVaultArgs = SourceVaultArgs(
        id = id,
    )
}
