@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the Spot-Try-Restore properties for the virtual machine scale set. With this property customer can enable or disable automatic restore of the evicted Spot VMSS VM instances opportunistically based on capacity availability and pricing constraint.
 * @property enabled Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based on capacity availability and pricing constraints
 * @property restoreTimeout Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
 */
public data class SpotRestorePolicyArgs(
    public val enabled: Output<Boolean>? = null,
    public val restoreTimeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs =
        com.pulumi.azurenative.compute.inputs.SpotRestorePolicyArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .restoreTimeout(restoreTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotRestorePolicyArgs].
 */
@PulumiTagMarker
public class SpotRestorePolicyArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var restoreTimeout: Output<String>? = null

    /**
     * @param value Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based on capacity availability and pricing constraints
     */
    @JvmName("rrkldmwesbbnrdbq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
     */
    @JvmName("brtcvjdryexaskey")
    public suspend fun restoreTimeout(`value`: Output<String>) {
        this.restoreTimeout = value
    }

    /**
     * @param value Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based on capacity availability and pricing constraints
     */
    @JvmName("buvdaibjfclrrmho")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
     */
    @JvmName("qogwgufvobxggiac")
    public suspend fun restoreTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTimeout = mapped
    }

    internal fun build(): SpotRestorePolicyArgs = SpotRestorePolicyArgs(
        enabled = enabled,
        restoreTimeout = restoreTimeout,
    )
}
