@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.StorageProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskControllerTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the storage settings for the virtual machine disks.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 * @property diskControllerType Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
 * @property imageReference Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
 * @property osDisk Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
 */
public data class StorageProfileArgs(
    public val dataDisks: Output<List<DataDiskArgs>>? = null,
    public val diskControllerType: Output<Either<String, DiskControllerTypes>>? = null,
    public val imageReference: Output<ImageReferenceArgs>? = null,
    public val osDisk: Output<OSDiskArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.StorageProfileArgs =
        com.pulumi.azurenative.compute.inputs.StorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .diskControllerType(
                diskControllerType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<DataDiskArgs>>? = null

    private var diskControllerType: Output<Either<String, DiskControllerTypes>>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var osDisk: Output<OSDiskArgs>? = null

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ltnxjmvidfjkjtiu")
    public suspend fun dataDisks(`value`: Output<List<DataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("umilalbmypllelvv")
    public suspend fun dataDisks(vararg values: Output<DataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("kucnxagslalvacbv")
    public suspend fun dataDisks(values: List<Output<DataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
     */
    @JvmName("veojdxismematlnp")
    public suspend fun diskControllerType(`value`: Output<Either<String, DiskControllerTypes>>) {
        this.diskControllerType = value
    }

    /**
     * @param value Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("fouagrltajtggkym")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("brdmkxwfthvtgwko")
    public suspend fun osDisk(`value`: Output<OSDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("toxubrofumymqrbl")
    public suspend fun dataDisks(`value`: List<DataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("favttnwtbgkmudoj")
    public suspend fun dataDisks(argument: List<suspend DataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("ttligckbwyesbyqx")
    public suspend fun dataDisks(vararg argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("wsawpbxmmwkyisew")
    public suspend fun dataDisks(argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("kgitnmdadpeqyriw")
    public suspend fun dataDisks(vararg values: DataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
     */
    @JvmName("rbbetoivhhneaayn")
    public suspend fun diskControllerType(`value`: Either<String, DiskControllerTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskControllerType = mapped
    }

    /**
     * @param value Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
     */
    @JvmName("bkettxevaqpreimx")
    public fun diskControllerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskControllerTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskControllerType = mapped
    }

    /**
     * @param value Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
     */
    @JvmName("jvaajffkwjltnvbr")
    public fun diskControllerType(`value`: DiskControllerTypes) {
        val toBeMapped = Either.ofRight<String, DiskControllerTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskControllerType = mapped
    }

    /**
     * @param value Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("ecmsodbdxqmnjhmu")
    public suspend fun imageReference(`value`: ImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
     */
    @JvmName("gihvxkpxggqsrifg")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("waiqhlvvjbolwxal")
    public suspend fun osDisk(`value`: OSDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JvmName("vqcnkaquyymifrmx")
    public suspend fun osDisk(argument: suspend OSDiskArgsBuilder.() -> Unit) {
        val toBeMapped = OSDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        dataDisks = dataDisks,
        diskControllerType = diskControllerType,
        imageReference = imageReference,
        osDisk = osDisk,
    )
}
