@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VaultCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
 * @property certificateStore For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
 * @property certificateUrl This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
 */
public data class VaultCertificateArgs(
    public val certificateStore: Output<String>? = null,
    public val certificateUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VaultCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VaultCertificateArgs =
        com.pulumi.azurenative.compute.inputs.VaultCertificateArgs.builder()
            .certificateStore(certificateStore?.applyValue({ args0 -> args0 }))
            .certificateUrl(certificateUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultCertificateArgs].
 */
@PulumiTagMarker
public class VaultCertificateArgsBuilder internal constructor() {
    private var certificateStore: Output<String>? = null

    private var certificateUrl: Output<String>? = null

    /**
     * @param value For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
     */
    @JvmName("udombmtqmvxipiux")
    public suspend fun certificateStore(`value`: Output<String>) {
        this.certificateStore = value
    }

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("bcdjhoxokxlulacn")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
     */
    @JvmName("cnavojuvwsepvkjx")
    public suspend fun certificateStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateStore = mapped
    }

    /**
     * @param value This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs&#46;microsoft&#46;com/azure/key-vault/key-vault-get-started/#add)&#46; In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("dusfwvbsuqwcdpkg")
    public suspend fun certificateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    internal fun build(): VaultCertificateArgs = VaultCertificateArgs(
        certificateStore = certificateStore,
        certificateUrl = certificateUrl,
    )
}
