@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineIpTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains the IP tag associated with the public IP address.
 * @property ipTagType IP tag type. Example: FirstPartyUsage.
 * @property tag IP tag associated with the public IP. Example: SQL, Storage etc.
 */
public data class VirtualMachineIpTagArgs(
    public val ipTagType: Output<String>? = null,
    public val tag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineIpTagArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineIpTagArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineIpTagArgs.builder()
            .ipTagType(ipTagType?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineIpTagArgs].
 */
@PulumiTagMarker
public class VirtualMachineIpTagArgsBuilder internal constructor() {
    private var ipTagType: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("nloqvroefxuhlwvs")
    public suspend fun ipTagType(`value`: Output<String>) {
        this.ipTagType = value
    }

    /**
     * @param value IP tag associated with the public IP. Example: SQL, Storage etc.
     */
    @JvmName("wupfejhowhdljbrh")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("dtwastpgilqrfaje")
    public suspend fun ipTagType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTagType = mapped
    }

    /**
     * @param value IP tag associated with the public IP. Example: SQL, Storage etc.
     */
    @JvmName("qpnxjlvywppftvhv")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): VirtualMachineIpTagArgs = VirtualMachineIpTagArgs(
        ipTagType = ipTagType,
        tag = tag,
    )
}
