@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.IPVersions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine network profile's IP configuration.
 * @property applicationGatewayBackendAddressPools Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
 * @property applicationSecurityGroups Specifies an array of references to application security group.
 * @property loadBalancerBackendAddressPools Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
 * @property name The IP configuration name.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 * @property privateIPAddressVersion Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
 * @property publicIPAddressConfiguration The publicIPAddressConfiguration.
 * @property subnet Specifies the identifier of the subnet.
 */
public data class VirtualMachineNetworkInterfaceIPConfigurationArgs(
    public val applicationGatewayBackendAddressPools: Output<List<SubResourceArgs>>? = null,
    public val applicationSecurityGroups: Output<List<SubResourceArgs>>? = null,
    public val loadBalancerBackendAddressPools: Output<List<SubResourceArgs>>? = null,
    public val name: Output<String>,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddressVersion: Output<Either<String, IPVersions>>? = null,
    public val publicIPAddressConfiguration: Output<VirtualMachinePublicIPAddressConfigurationArgs>? =
        null,
    public val subnet: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs.builder()
            .applicationGatewayBackendAddressPools(
                applicationGatewayBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .applicationSecurityGroups(
                applicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancerBackendAddressPools(
                loadBalancerBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddressVersion(
                privateIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddressConfiguration(
                publicIPAddressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineNetworkInterfaceIPConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder internal constructor() {
    private var applicationGatewayBackendAddressPools: Output<List<SubResourceArgs>>? = null

    private var applicationSecurityGroups: Output<List<SubResourceArgs>>? = null

    private var loadBalancerBackendAddressPools: Output<List<SubResourceArgs>>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddressVersion: Output<Either<String, IPVersions>>? = null

    private var publicIPAddressConfiguration: Output<VirtualMachinePublicIPAddressConfigurationArgs>? =
        null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("clvnjkmuxdcudsut")
    public suspend fun applicationGatewayBackendAddressPools(`value`: Output<List<SubResourceArgs>>) {
        this.applicationGatewayBackendAddressPools = value
    }

    @JvmName("ouuuxxipxurmdvss")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: Output<SubResourceArgs>) {
        this.applicationGatewayBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("qivngrplxwwfyhnn")
    public suspend fun applicationGatewayBackendAddressPools(values: List<Output<SubResourceArgs>>) {
        this.applicationGatewayBackendAddressPools = Output.all(values)
    }

    /**
     * @param value Specifies an array of references to application security group.
     */
    @JvmName("ytfqamheivctbtaa")
    public suspend fun applicationSecurityGroups(`value`: Output<List<SubResourceArgs>>) {
        this.applicationSecurityGroups = value
    }

    @JvmName("kweeghrqetwcyevp")
    public suspend fun applicationSecurityGroups(vararg values: Output<SubResourceArgs>) {
        this.applicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to application security group.
     */
    @JvmName("ibgernpmlsgojicw")
    public suspend fun applicationSecurityGroups(values: List<Output<SubResourceArgs>>) {
        this.applicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("uqmxhlqtvjpyydxo")
    public suspend fun loadBalancerBackendAddressPools(`value`: Output<List<SubResourceArgs>>) {
        this.loadBalancerBackendAddressPools = value
    }

    @JvmName("rkmtuhxjjyixdiiq")
    public suspend fun loadBalancerBackendAddressPools(vararg values: Output<SubResourceArgs>) {
        this.loadBalancerBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("alrnutogxohlocqj")
    public suspend fun loadBalancerBackendAddressPools(values: List<Output<SubResourceArgs>>) {
        this.loadBalancerBackendAddressPools = Output.all(values)
    }

    /**
     * @param value The IP configuration name.
     */
    @JvmName("oamprerhhdepunvd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("umyahclejxwocldg")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("eycucfgerbplanle")
    public suspend fun privateIPAddressVersion(`value`: Output<Either<String, IPVersions>>) {
        this.privateIPAddressVersion = value
    }

    /**
     * @param value The publicIPAddressConfiguration.
     */
    @JvmName("cckutkoanrrmlsjt")
    public suspend fun publicIPAddressConfiguration(`value`: Output<VirtualMachinePublicIPAddressConfigurationArgs>) {
        this.publicIPAddressConfiguration = value
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("pqyoqkjaubtuoqux")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("mcrimtiddmoskjce")
    public suspend fun applicationGatewayBackendAddressPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("cxmkqaautqaamktc")
    public suspend fun applicationGatewayBackendAddressPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("pyiaqrefayvmwvsb")
    public suspend fun applicationGatewayBackendAddressPools(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("slycmbnjfnerfoeo")
    public suspend fun applicationGatewayBackendAddressPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param values Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.
     */
    @JvmName("afvhyeuulcofawyb")
    public suspend fun applicationGatewayBackendAddressPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayBackendAddressPools = mapped
    }

    /**
     * @param value Specifies an array of references to application security group.
     */
    @JvmName("xkvgmauwdanjceic")
    public suspend fun applicationSecurityGroups(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("lsowarjqyujyixxt")
    public suspend fun applicationSecurityGroups(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("spqecquxtllbdleg")
    public suspend fun applicationSecurityGroups(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Specifies an array of references to application security group.
     */
    @JvmName("oiyhipoavnhinvja")
    public suspend fun applicationSecurityGroups(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param values Specifies an array of references to application security group.
     */
    @JvmName("mswynhllinshgwsy")
    public suspend fun applicationSecurityGroups(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param value Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("cdrbdocirqjqvgnf")
    public suspend fun loadBalancerBackendAddressPools(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("bdqqwvajegnnhibj")
    public suspend fun loadBalancerBackendAddressPools(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("iepxitowgxwumnsx")
    public suspend fun loadBalancerBackendAddressPools(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("xksodijmpvlwwvkt")
    public suspend fun loadBalancerBackendAddressPools(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param values Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].
     */
    @JvmName("jsuaphbwmcggjxev")
    public suspend fun loadBalancerBackendAddressPools(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param value The IP configuration name.
     */
    @JvmName("pyrrjthhkfhncxiw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("lwufmcxfbirbqsow")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("jjjhucbfyldtixic")
    public suspend fun privateIPAddressVersion(`value`: Either<String, IPVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("wdcqxewddwxrhlwp")
    public fun privateIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
     */
    @JvmName("oagnbfcwfiiqnhbd")
    public fun privateIPAddressVersion(`value`: IPVersions) {
        val toBeMapped = Either.ofRight<String, IPVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value The publicIPAddressConfiguration.
     */
    @JvmName("wxymvyjoovmqtwjo")
    public suspend fun publicIPAddressConfiguration(`value`: VirtualMachinePublicIPAddressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param argument The publicIPAddressConfiguration.
     */
    @JvmName("srlmcxqtlabgxksd")
    public suspend fun publicIPAddressConfiguration(argument: suspend VirtualMachinePublicIPAddressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePublicIPAddressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddressConfiguration = mapped
    }

    /**
     * @param value Specifies the identifier of the subnet.
     */
    @JvmName("xjhyxkswxnqvyelv")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Specifies the identifier of the subnet.
     */
    @JvmName("dpfhwlslasxgjddf")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): VirtualMachineNetworkInterfaceIPConfigurationArgs =
        VirtualMachineNetworkInterfaceIPConfigurationArgs(
            applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools,
            applicationSecurityGroups = applicationSecurityGroups,
            loadBalancerBackendAddressPools = loadBalancerBackendAddressPools,
            name = name ?: throw PulumiNullFieldException("name"),
            primary = primary,
            privateIPAddressVersion = privateIPAddressVersion,
            publicIPAddressConfiguration = publicIPAddressConfiguration,
            subnet = subnet,
        )
}
