@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetDataDiskArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CachingTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskCreateOptionTypes
import com.pulumi.azurenative.compute.kotlin.enums.DiskDeleteOptionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set data disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption The create option.
 * @property deleteOption Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
 * @property diskIOPSReadWrite Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
 * @property diskMBpsReadWrite Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property lun Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class VirtualMachineScaleSetDataDiskArgs(
    public val caching: Output<CachingTypes>? = null,
    public val createOption: Output<Either<String, DiskCreateOptionTypes>>,
    public val deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null,
    public val diskIOPSReadWrite: Output<Double>? = null,
    public val diskMBpsReadWrite: Output<Double>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val lun: Output<Int>,
    public val managedDisk: Output<VirtualMachineScaleSetManagedDiskParametersArgs>? = null,
    public val name: Output<String>? = null,
    public val writeAcceleratorEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetDataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetDataDiskArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetDataDiskArgs.builder()
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createOption(
                createOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskIOPSReadWrite(diskIOPSReadWrite?.applyValue({ args0 -> args0 }))
            .diskMBpsReadWrite(diskMBpsReadWrite?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .lun(lun.applyValue({ args0 -> args0 }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .writeAcceleratorEnabled(writeAcceleratorEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetDataDiskArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetDataDiskArgsBuilder internal constructor() {
    private var caching: Output<CachingTypes>? = null

    private var createOption: Output<Either<String, DiskCreateOptionTypes>>? = null

    private var deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null

    private var diskIOPSReadWrite: Output<Double>? = null

    private var diskMBpsReadWrite: Output<Double>? = null

    private var diskSizeGB: Output<Int>? = null

    private var lun: Output<Int>? = null

    private var managedDisk: Output<VirtualMachineScaleSetManagedDiskParametersArgs>? = null

    private var name: Output<String>? = null

    private var writeAcceleratorEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("hjxcvarcwtaeitiu")
    public suspend fun caching(`value`: Output<CachingTypes>) {
        this.caching = value
    }

    /**
     * @param value The create option.
     */
    @JvmName("ppgmkjwbqkvqfbbg")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOptionTypes>>) {
        this.createOption = value
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
     */
    @JvmName("tlqvibtalrsdgbje")
    public suspend fun deleteOption(`value`: Output<Either<String, DiskDeleteOptionTypes>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
     */
    @JvmName("pfgmbcqgfiskjjlg")
    public suspend fun diskIOPSReadWrite(`value`: Output<Double>) {
        this.diskIOPSReadWrite = value
    }

    /**
     * @param value Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
     */
    @JvmName("txvtgrlfvcsaqutw")
    public suspend fun diskMBpsReadWrite(`value`: Output<Double>) {
        this.diskMBpsReadWrite = value
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("hixldxkgigcddeml")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("fnihfrgwtmvklwah")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("nyqrkhoxrjeywqjm")
    public suspend fun managedDisk(`value`: Output<VirtualMachineScaleSetManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value The disk name.
     */
    @JvmName("gifdamprvachcqav")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("dcchpyicbouxrvxa")
    public suspend fun writeAcceleratorEnabled(`value`: Output<Boolean>) {
        this.writeAcceleratorEnabled = value
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("swvtfdshdhipyqql")
    public suspend fun caching(`value`: CachingTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value The create option.
     */
    @JvmName("churqvldecmphbqx")
    public suspend fun createOption(`value`: Either<String, DiskCreateOptionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The create option.
     */
    @JvmName("puiqyvcadihlacue")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The create option.
     */
    @JvmName("sdbsdrvynwhwgfkf")
    public fun createOption(`value`: DiskCreateOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
     */
    @JvmName("defbdscwspbjcbml")
    public suspend fun deleteOption(`value`: Either<String, DiskDeleteOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
     */
    @JvmName("mehyfyihtslftsvx")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.
     */
    @JvmName("qtbuygmusskiodlb")
    public fun deleteOption(`value`: DiskDeleteOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
     */
    @JvmName("eetbcuddpgkdvqwy")
    public suspend fun diskIOPSReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIOPSReadWrite = mapped
    }

    /**
     * @param value Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.
     */
    @JvmName("kqyhhciruwauttaq")
    public suspend fun diskMBpsReadWrite(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskMBpsReadWrite = mapped
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("aobxvftdlscumkpe")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
     */
    @JvmName("igfggqxcviamdbgo")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("huychbioqxtjfjfc")
    public suspend fun managedDisk(`value`: VirtualMachineScaleSetManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument The managed disk parameters.
     */
    @JvmName("djhwckabcwtmdfra")
    public suspend fun managedDisk(argument: suspend VirtualMachineScaleSetManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetManagedDiskParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("llnqwpqpdmgutvfo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("appdjlglndypnngk")
    public suspend fun writeAcceleratorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAcceleratorEnabled = mapped
    }

    internal fun build(): VirtualMachineScaleSetDataDiskArgs = VirtualMachineScaleSetDataDiskArgs(
        caching = caching,
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        deleteOption = deleteOption,
        diskIOPSReadWrite = diskIOPSReadWrite,
        diskMBpsReadWrite = diskMBpsReadWrite,
        diskSizeGB = diskSizeGB,
        lun = lun ?: throw PulumiNullFieldException("lun"),
        managedDisk = managedDisk,
        name = name,
        writeAcceleratorEnabled = writeAcceleratorEnabled,
    )
}
