@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property dnsServers List of DNS servers IP addresses
 */
public data class VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs(
    public val dnsServers: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    /**
     * @param value List of DNS servers IP addresses
     */
    @JvmName("neqokoxqedxauwvm")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("ygoputblsqqtlqxp")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values List of DNS servers IP addresses
     */
    @JvmName("fhdoktvqdxpdmvxn")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value List of DNS servers IP addresses
     */
    @JvmName("fxyreabypuldclyo")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values List of DNS servers IP addresses
     */
    @JvmName("kxvreodtaquepdoi")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    internal fun build(): VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs =
        VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs(
            dnsServers = dnsServers,
        )
}
