@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.VirtualMachineEvictionPolicyTypes
import com.pulumi.azurenative.compute.kotlin.enums.VirtualMachinePriorityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set virtual machine profile.
 * @property applicationProfile Specifies the gallery applications that should be made available to the VM/VMSS
 * @property billingProfile Specifies the billing related details of a Azure Spot VMSS. Minimum api-version: 2019-03-01.
 * @property capacityReservation Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property evictionPolicy Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
 * @property extensionProfile Specifies a collection of settings for extensions installed on virtual machines in the scale set.
 * @property hardwareProfile Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property networkProfile Specifies properties of the network interfaces of the virtual machines in the scale set.
 * @property osProfile Specifies the operating system settings for the virtual machines in the scale set.
 * @property priority Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
 * @property scheduledEventsProfile Specifies Scheduled Event related configurations.
 * @property securityPostureReference Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
 * @property securityProfile Specifies the Security related profile settings for the virtual machines in the scale set.
 * @property serviceArtifactReference Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property userData UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
 */
public data class VirtualMachineScaleSetVMProfileArgs(
    public val applicationProfile: Output<ApplicationProfileArgs>? = null,
    public val billingProfile: Output<BillingProfileArgs>? = null,
    public val capacityReservation: Output<CapacityReservationProfileArgs>? = null,
    public val diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null,
    public val evictionPolicy: Output<Either<String, VirtualMachineEvictionPolicyTypes>>? = null,
    public val extensionProfile: Output<VirtualMachineScaleSetExtensionProfileArgs>? = null,
    public val hardwareProfile: Output<VirtualMachineScaleSetHardwareProfileArgs>? = null,
    public val licenseType: Output<String>? = null,
    public val networkProfile: Output<VirtualMachineScaleSetNetworkProfileArgs>? = null,
    public val osProfile: Output<VirtualMachineScaleSetOSProfileArgs>? = null,
    public val priority: Output<Either<String, VirtualMachinePriorityTypes>>? = null,
    public val scheduledEventsProfile: Output<ScheduledEventsProfileArgs>? = null,
    public val securityPostureReference: Output<SecurityPostureReferenceArgs>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val serviceArtifactReference: Output<ServiceArtifactReferenceArgs>? = null,
    public val storageProfile: Output<VirtualMachineScaleSetStorageProfileArgs>? = null,
    public val userData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMProfileArgs.builder()
            .applicationProfile(
                applicationProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .billingProfile(billingProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .capacityReservation(
                capacityReservation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .diagnosticsProfile(
                diagnosticsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .evictionPolicy(
                evictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extensionProfile(extensionProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(
                priority?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scheduledEventsProfile(
                scheduledEventsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityPostureReference(
                securityPostureReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceArtifactReference(
                serviceArtifactReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userData(userData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMProfileArgsBuilder internal constructor() {
    private var applicationProfile: Output<ApplicationProfileArgs>? = null

    private var billingProfile: Output<BillingProfileArgs>? = null

    private var capacityReservation: Output<CapacityReservationProfileArgs>? = null

    private var diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null

    private var evictionPolicy: Output<Either<String, VirtualMachineEvictionPolicyTypes>>? = null

    private var extensionProfile: Output<VirtualMachineScaleSetExtensionProfileArgs>? = null

    private var hardwareProfile: Output<VirtualMachineScaleSetHardwareProfileArgs>? = null

    private var licenseType: Output<String>? = null

    private var networkProfile: Output<VirtualMachineScaleSetNetworkProfileArgs>? = null

    private var osProfile: Output<VirtualMachineScaleSetOSProfileArgs>? = null

    private var priority: Output<Either<String, VirtualMachinePriorityTypes>>? = null

    private var scheduledEventsProfile: Output<ScheduledEventsProfileArgs>? = null

    private var securityPostureReference: Output<SecurityPostureReferenceArgs>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var serviceArtifactReference: Output<ServiceArtifactReferenceArgs>? = null

    private var storageProfile: Output<VirtualMachineScaleSetStorageProfileArgs>? = null

    private var userData: Output<String>? = null

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("qxfeuesyceumsavl")
    public suspend fun applicationProfile(`value`: Output<ApplicationProfileArgs>) {
        this.applicationProfile = value
    }

    /**
     * @param value Specifies the billing related details of a Azure Spot VMSS. Minimum api-version: 2019-03-01.
     */
    @JvmName("vmdldrhjtnfptdbi")
    public suspend fun billingProfile(`value`: Output<BillingProfileArgs>) {
        this.billingProfile = value
    }

    /**
     * @param value Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.
     */
    @JvmName("xjdrjeakaohlpkcb")
    public suspend fun capacityReservation(`value`: Output<CapacityReservationProfileArgs>) {
        this.capacityReservation = value
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("xaubugxnbxuwajoj")
    public suspend fun diagnosticsProfile(`value`: Output<DiagnosticsProfileArgs>) {
        this.diagnosticsProfile = value
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("vseuohfhclbqhwbf")
    public suspend fun evictionPolicy(`value`: Output<Either<String, VirtualMachineEvictionPolicyTypes>>) {
        this.evictionPolicy = value
    }

    /**
     * @param value Specifies a collection of settings for extensions installed on virtual machines in the scale set.
     */
    @JvmName("tqecrbyssrrljout")
    public suspend fun extensionProfile(`value`: Output<VirtualMachineScaleSetExtensionProfileArgs>) {
        this.extensionProfile = value
    }

    /**
     * @param value Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.
     */
    @JvmName("awnqhcktjuejadio")
    public suspend fun hardwareProfile(`value`: Output<VirtualMachineScaleSetHardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("uaciplvsdhdgfqtx")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value Specifies properties of the network interfaces of the virtual machines in the scale set.
     */
    @JvmName("qovqnrhadmecvkkg")
    public suspend fun networkProfile(`value`: Output<VirtualMachineScaleSetNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Specifies the operating system settings for the virtual machines in the scale set.
     */
    @JvmName("krjyemlphtrjetwh")
    public suspend fun osProfile(`value`: Output<VirtualMachineScaleSetOSProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
     */
    @JvmName("gircropbxwnlgqhn")
    public suspend fun priority(`value`: Output<Either<String, VirtualMachinePriorityTypes>>) {
        this.priority = value
    }

    /**
     * @param value Specifies Scheduled Event related configurations.
     */
    @JvmName("faowqsdelxhyphsm")
    public suspend fun scheduledEventsProfile(`value`: Output<ScheduledEventsProfileArgs>) {
        this.scheduledEventsProfile = value
    }

    /**
     * @param value Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
     */
    @JvmName("blbnojewqanabwst")
    public suspend fun securityPostureReference(`value`: Output<SecurityPostureReferenceArgs>) {
        this.securityPostureReference = value
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machines in the scale set.
     */
    @JvmName("oyhnvfxtseygrkya")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
     */
    @JvmName("fhmkdilwdaqldqfa")
    public suspend fun serviceArtifactReference(`value`: Output<ServiceArtifactReferenceArgs>) {
        this.serviceArtifactReference = value
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("wcsgtpryurhorsfl")
    public suspend fun storageProfile(`value`: Output<VirtualMachineScaleSetStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
     */
    @JvmName("hxityuxgnibmwrgu")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("jtlqtbgbqbchjexp")
    public suspend fun applicationProfile(`value`: ApplicationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationProfile = mapped
    }

    /**
     * @param argument Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("wrswlxyrckgpgbnj")
    public suspend fun applicationProfile(argument: suspend ApplicationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationProfile = mapped
    }

    /**
     * @param value Specifies the billing related details of a Azure Spot VMSS. Minimum api-version: 2019-03-01.
     */
    @JvmName("lvfettrdriqljrro")
    public suspend fun billingProfile(`value`: BillingProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingProfile = mapped
    }

    /**
     * @param argument Specifies the billing related details of a Azure Spot VMSS. Minimum api-version: 2019-03-01.
     */
    @JvmName("jsexpmjmcumiinwi")
    public suspend fun billingProfile(argument: suspend BillingProfileArgsBuilder.() -> Unit) {
        val toBeMapped = BillingProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.billingProfile = mapped
    }

    /**
     * @param value Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.
     */
    @JvmName("lnijtuwsvgartutc")
    public suspend fun capacityReservation(`value`: CapacityReservationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservation = mapped
    }

    /**
     * @param argument Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.
     */
    @JvmName("lepsqtqpkmkcyttm")
    public suspend fun capacityReservation(argument: suspend CapacityReservationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CapacityReservationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacityReservation = mapped
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("xtnlrwjfpwqavgxg")
    public suspend fun diagnosticsProfile(`value`: DiagnosticsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsProfile = mapped
    }

    /**
     * @param argument Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("qoylymyrexgwclts")
    public suspend fun diagnosticsProfile(argument: suspend DiagnosticsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnosticsProfile = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("ijxalevhkstidjnf")
    public suspend fun evictionPolicy(`value`: Either<String, VirtualMachineEvictionPolicyTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("hxjnsfbiqepaxxlv")
    public fun evictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineEvictionPolicyTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("xccsjqcswdgbyusb")
    public fun evictionPolicy(`value`: VirtualMachineEvictionPolicyTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachineEvictionPolicyTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies a collection of settings for extensions installed on virtual machines in the scale set.
     */
    @JvmName("broimqowxdpqhtyd")
    public suspend fun extensionProfile(`value`: VirtualMachineScaleSetExtensionProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionProfile = mapped
    }

    /**
     * @param argument Specifies a collection of settings for extensions installed on virtual machines in the scale set.
     */
    @JvmName("kifkgtmgvyhalrtj")
    public suspend fun extensionProfile(argument: suspend VirtualMachineScaleSetExtensionProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetExtensionProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extensionProfile = mapped
    }

    /**
     * @param value Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.
     */
    @JvmName("uoshstlfhxiihjpx")
    public suspend fun hardwareProfile(`value`: VirtualMachineScaleSetHardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.
     */
    @JvmName("xnoesirxphgsqbkr")
    public suspend fun hardwareProfile(argument: suspend VirtualMachineScaleSetHardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetHardwareProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("xqbkyclbeokeyeba")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Specifies properties of the network interfaces of the virtual machines in the scale set.
     */
    @JvmName("ephltkhexglrdiri")
    public suspend fun networkProfile(`value`: VirtualMachineScaleSetNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Specifies properties of the network interfaces of the virtual machines in the scale set.
     */
    @JvmName("glpvuxlcpoiaewrm")
    public suspend fun networkProfile(argument: suspend VirtualMachineScaleSetNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetNetworkProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Specifies the operating system settings for the virtual machines in the scale set.
     */
    @JvmName("rcrjrbdsjlihjyqk")
    public suspend fun osProfile(`value`: VirtualMachineScaleSetOSProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings for the virtual machines in the scale set.
     */
    @JvmName("xoairpgyoujkpgcg")
    public suspend fun osProfile(argument: suspend VirtualMachineScaleSetOSProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetOSProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
     */
    @JvmName("xvcwcepwvrxudily")
    public suspend fun priority(`value`: Either<String, VirtualMachinePriorityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
     */
    @JvmName("arqmhhjosifiwqcx")
    public fun priority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachinePriorityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machines in the scale set. Minimum api-version: 2017-10-30-preview.
     */
    @JvmName("bqfjreaddcxibrqk")
    public fun priority(`value`: VirtualMachinePriorityTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachinePriorityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies Scheduled Event related configurations.
     */
    @JvmName("wpkgbfgggyjftkwa")
    public suspend fun scheduledEventsProfile(`value`: ScheduledEventsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledEventsProfile = mapped
    }

    /**
     * @param argument Specifies Scheduled Event related configurations.
     */
    @JvmName("achnnvtnsedlynts")
    public suspend fun scheduledEventsProfile(argument: suspend ScheduledEventsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledEventsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduledEventsProfile = mapped
    }

    /**
     * @param value Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
     */
    @JvmName("vrhauyncxvgfddrt")
    public suspend fun securityPostureReference(`value`: SecurityPostureReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPostureReference = mapped
    }

    /**
     * @param argument Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
     */
    @JvmName("toxlatfgvvsaplvy")
    public suspend fun securityPostureReference(argument: suspend SecurityPostureReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityPostureReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityPostureReference = mapped
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machines in the scale set.
     */
    @JvmName("rpbfepvhpnfvlres")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Specifies the Security related profile settings for the virtual machines in the scale set.
     */
    @JvmName("radlkhskhthpjjbx")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
     */
    @JvmName("dwltklcrukyfcmtt")
    public suspend fun serviceArtifactReference(`value`: ServiceArtifactReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceArtifactReference = mapped
    }

    /**
     * @param argument Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
     */
    @JvmName("ppfjtqbdddvbmufb")
    public suspend fun serviceArtifactReference(argument: suspend ServiceArtifactReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceArtifactReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceArtifactReference = mapped
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("xlelxiagehcfongh")
    public suspend fun storageProfile(`value`: VirtualMachineScaleSetStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("ekjxkwmlhqhfrpkj")
    public suspend fun storageProfile(argument: suspend VirtualMachineScaleSetStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
     */
    @JvmName("hynykxjolpeeblhe")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMProfileArgs = VirtualMachineScaleSetVMProfileArgs(
        applicationProfile = applicationProfile,
        billingProfile = billingProfile,
        capacityReservation = capacityReservation,
        diagnosticsProfile = diagnosticsProfile,
        evictionPolicy = evictionPolicy,
        extensionProfile = extensionProfile,
        hardwareProfile = hardwareProfile,
        licenseType = licenseType,
        networkProfile = networkProfile,
        osProfile = osProfile,
        priority = priority,
        scheduledEventsProfile = scheduledEventsProfile,
        securityPostureReference = securityPostureReference,
        securityProfile = securityProfile,
        serviceArtifactReference = serviceArtifactReference,
        storageProfile = storageProfile,
        userData = userData,
    )
}
