@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration parameters used for performing automatic OS upgrade.
 * @property disableAutomaticRollback Whether OS image rollback feature should be disabled. Default value is false.
 * @property enableAutomaticOSUpgrade Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. Default value is false. If this is set to true for Windows based scale sets, [enableAutomaticUpdates](https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet) is automatically set to false and cannot be set to true.
 * @property useRollingUpgradePolicy Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS.
 */
public data class AutomaticOSUpgradePolicyResponse(
    public val disableAutomaticRollback: Boolean? = null,
    public val enableAutomaticOSUpgrade: Boolean? = null,
    public val useRollingUpgradePolicy: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.AutomaticOSUpgradePolicyResponse): AutomaticOSUpgradePolicyResponse = AutomaticOSUpgradePolicyResponse(
            disableAutomaticRollback = javaType.disableAutomaticRollback().map({ args0 -> args0 }).orElse(null),
            enableAutomaticOSUpgrade = javaType.enableAutomaticOSUpgrade().map({ args0 -> args0 }).orElse(null),
            useRollingUpgradePolicy = javaType.useRollingUpgradePolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
