@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
 * @property enabled Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
 * @property gracePeriod The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
 * @property repairAction Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
 */
public data class AutomaticRepairsPolicyResponse(
    public val enabled: Boolean? = null,
    public val gracePeriod: String? = null,
    public val repairAction: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.AutomaticRepairsPolicyResponse): AutomaticRepairsPolicyResponse = AutomaticRepairsPolicyResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            gracePeriod = javaType.gracePeriod().map({ args0 -> args0 }).orElse(null),
            repairAction = javaType.repairAction().map({ args0 -> args0 }).orElse(null),
        )
    }
}
