@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of an virtual machine instance view for available patch summary.
 * @property assessmentActivityId The activity ID of the operation that produced this result. It is used to correlate across CRP and extension logs.
 * @property criticalAndSecurityPatchCount The number of critical or security patches that have been detected as available and not yet installed.
 * @property error The errors that were encountered during execution of the operation. The details array contains the list of them.
 * @property lastModifiedTime The UTC timestamp when the operation began.
 * @property otherPatchCount The number of all available patches excluding critical and security.
 * @property rebootPending The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred.
 * @property startTime The UTC timestamp when the operation began.
 * @property status The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings."
 */
public data class AvailablePatchSummaryResponse(
    public val assessmentActivityId: String,
    public val criticalAndSecurityPatchCount: Int,
    public val error: ApiErrorResponse,
    public val lastModifiedTime: String,
    public val otherPatchCount: Int,
    public val rebootPending: Boolean,
    public val startTime: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.AvailablePatchSummaryResponse): AvailablePatchSummaryResponse = AvailablePatchSummaryResponse(
            assessmentActivityId = javaType.assessmentActivityId(),
            criticalAndSecurityPatchCount = javaType.criticalAndSecurityPatchCount(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.compute.kotlin.outputs.ApiErrorResponse.Companion.toKotlin(args0)
            }),
            lastModifiedTime = javaType.lastModifiedTime(),
            otherPatchCount = javaType.otherPatchCount(),
            rebootPending = javaType.rebootPending(),
            startTime = javaType.startTime(),
            status = javaType.status(),
        )
    }
}
