@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network Profile for the cloud service.
 * @property loadBalancerConfigurations List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
 * @property slotType Slot type for the cloud service.
 * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
 * If not specified, the default value is Production.
 * @property swappableCloudService The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
 */
public data class CloudServiceNetworkProfileResponse(
    public val loadBalancerConfigurations: List<LoadBalancerConfigurationResponse>? = null,
    public val slotType: String? = null,
    public val swappableCloudService: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceNetworkProfileResponse): CloudServiceNetworkProfileResponse = CloudServiceNetworkProfileResponse(
            loadBalancerConfigurations = javaType.loadBalancerConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.LoadBalancerConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            slotType = javaType.slotType().map({ args0 -> args0 }).orElse(null),
            swappableCloudService = javaType.swappableCloudService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
