@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Describes the cloud service role sku.
 * @property capacity Specifies the number of role instances in the cloud service.
 * @property name The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
 * @property tier Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
 */
public data class CloudServiceRoleSkuResponse(
    public val capacity: Double? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CloudServiceRoleSkuResponse): CloudServiceRoleSkuResponse = CloudServiceRoleSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
