@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
 * @property errorCode Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
 * @property errorMessage Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
 */
public data class CopyCompletionErrorResponse(
    public val errorCode: String,
    public val errorMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.CopyCompletionErrorResponse): CopyCompletionErrorResponse = CopyCompletionErrorResponse(
            errorCode = javaType.errorCode(),
            errorMessage = javaType.errorMessage(),
        )
    }
}
