@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Contains encryption settings for a data disk image.
 * @property diskEncryptionSetId A relative URI containing the resource ID of the disk encryption set.
 * @property lun This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
 */
public data class DataDiskImageEncryptionResponse(
    public val diskEncryptionSetId: String? = null,
    public val lun: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DataDiskImageEncryptionResponse): DataDiskImageEncryptionResponse = DataDiskImageEncryptionResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            lun = javaType.lun(),
        )
    }
}
