@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Dedicated host unutilized capacity.
 * @property allocatableVMs The unutilized capacity of the dedicated host represented in terms of each VM size that is allowed to be deployed to the dedicated host.
 */
public data class DedicatedHostAvailableCapacityResponse(
    public val allocatableVMs: List<DedicatedHostAllocatableVMResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DedicatedHostAvailableCapacityResponse): DedicatedHostAvailableCapacityResponse = DedicatedHostAvailableCapacityResponse(
            allocatableVMs = javaType.allocatableVMs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostAllocatableVMResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
