@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
 * @property ultraSSDEnabled The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of the Dedicated Host Group. For the Virtual Machines to be UltraSSD Enabled, UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not provided. Please refer to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD feature. **Note:** The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal. Minimum api-version: 2022-03-01.
 */
public data class DedicatedHostGroupPropertiesResponseAdditionalCapabilities(
    public val ultraSSDEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DedicatedHostGroupPropertiesResponseAdditionalCapabilities): DedicatedHostGroupPropertiesResponseAdditionalCapabilities =
            DedicatedHostGroupPropertiesResponseAdditionalCapabilities(
                ultraSSDEnabled = javaType.ultraSSDEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
