@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The instance view of a disk restore point.
 * @property id Disk restore point Id.
 * @property replicationStatus The disk restore point replication status information.
 */
public data class DiskRestorePointInstanceViewResponse(
    public val id: String? = null,
    public val replicationStatus: DiskRestorePointReplicationStatusResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskRestorePointInstanceViewResponse): DiskRestorePointInstanceViewResponse = DiskRestorePointInstanceViewResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            replicationStatus = javaType.replicationStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.DiskRestorePointReplicationStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
