@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The instance view of a disk restore point.
 * @property completionPercent Replication completion percentage.
 * @property status The resource status information.
 */
public data class DiskRestorePointReplicationStatusResponse(
    public val completionPercent: Int? = null,
    public val status: InstanceViewStatusResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskRestorePointReplicationStatusResponse): DiskRestorePointReplicationStatusResponse = DiskRestorePointReplicationStatusResponse(
            completionPercent = javaType.completionPercent().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
