@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains the security related information for the resource.
 * @property secureVMDiskEncryptionSetId ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
 * @property securityType Specifies the SecurityType of the VM. Applicable for OS disks only.
 */
public data class DiskSecurityProfileResponse(
    public val secureVMDiskEncryptionSetId: String? = null,
    public val securityType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.DiskSecurityProfileResponse): DiskSecurityProfileResponse = DiskSecurityProfileResponse(
            secureVMDiskEncryptionSetId = javaType.secureVMDiskEncryptionSetId().map({ args0 ->
                args0
            }).orElse(null),
            securityType = javaType.securityType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
