@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption at rest settings for disk or snapshot
 * @property diskEncryptionSetId ResourceId of the disk encryption set to use for enabling encryption at rest.
 * @property type The type of key used to encrypt the data of the disk.
 */
public data class EncryptionResponse(
    public val diskEncryptionSetId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.EncryptionResponse): EncryptionResponse = EncryptionResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
