@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Encryption settings for disk or snapshot
 * @property enabled Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
 * @property encryptionSettings A collection of encryption settings, one for each disk volume.
 * @property encryptionSettingsVersion Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
 */
public data class EncryptionSettingsCollectionResponse(
    public val enabled: Boolean,
    public val encryptionSettings: List<EncryptionSettingsElementResponse>? = null,
    public val encryptionSettingsVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.EncryptionSettingsCollectionResponse): EncryptionSettingsCollectionResponse = EncryptionSettingsCollectionResponse(
            enabled = javaType.enabled(),
            encryptionSettings = javaType.encryptionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsElementResponse.Companion.toKotlin(args0)
                })
            }),
            encryptionSettingsVersion = javaType.encryptionSettingsVersion().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
