@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A custom action that can be performed with a Gallery Application Version.
 * @property description Description to help the users understand what this custom action does.
 * @property name The name of the custom action.  Must be unique within the Gallery Application Version.
 * @property parameters The parameters that this custom action uses
 * @property script The script to run when executing this custom action.
 */
public data class GalleryApplicationCustomActionResponse(
    public val description: String? = null,
    public val name: String,
    public val parameters: List<GalleryApplicationCustomActionParameterResponse>? = null,
    public val script: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryApplicationCustomActionResponse): GalleryApplicationCustomActionResponse = GalleryApplicationCustomActionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.compute.kotlin.outputs.GalleryApplicationCustomActionParameterResponse.Companion.toKotlin(args0)
                })
            }),
            script = javaType.script(),
        )
    }
}
