@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The safety profile of the Gallery Application Version.
 * @property allowDeletionOfReplicatedLocations Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
 */
public data class GalleryApplicationVersionSafetyProfileResponse(
    public val allowDeletionOfReplicatedLocations: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryApplicationVersionSafetyProfileResponse): GalleryApplicationVersionSafetyProfileResponse =
            GalleryApplicationVersionSafetyProfileResponse(
                allowDeletionOfReplicatedLocations = javaType.allowDeletionOfReplicatedLocations().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
