@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The source of the gallery artifact version.
 * @property communityGalleryImageId The resource Id of the source Community Gallery Image.  Only required when using Community Gallery Image as a source.
 * @property id The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
 */
public data class GalleryArtifactVersionFullSourceResponse(
    public val communityGalleryImageId: String? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.GalleryArtifactVersionFullSourceResponse): GalleryArtifactVersionFullSourceResponse = GalleryArtifactVersionFullSourceResponse(
            communityGalleryImageId = javaType.communityGalleryImageId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
